# Copyright (c) 2004 - 2008 16 Systems, LLC
# Copyright (c) 2009 Virginia Polytechnic Institute and State University
# All rights reserved.
#
# License & Redistribution Information
# http://www.security.vt.edu/Find_SSNs/find_ssns_license.html


import getopt
import os
import os.path
import sys
import getpass
# local imports
import version
import user
import skip
import create
import numbers
import targets
import hunt
import gv

# Run Program

ok_options = 'p:P:o:O:t:T:sScCaAevf'
usage = '\n\nProper usage on Linux, Unix and Macs:\nNoGUI: python Find_SSNs.pyw -p /search/folder -o /output/folder -t html -a\nGUI: python Find_SSNs.pyw\n\nProper usage on Windows:\nNoGUI: Find_SSNs.exe -p c:/search/folder -o c:/output/folder -t html -a\nGUI: Find_SSNs.exe\n\nNotes:\n-p The folder to search.\n-o The folder to write reports to.\n-t may be html or csv\n-a may be replaced by -s (search for SSNs only) or -c (search for CCNs and SSNs only)'

try:
    options, arguments = getopt.getopt(sys.argv[1:], ok_options)
    #print options, arguments
except getopt.GetoptError, e:
    #print e
    # User gave the wrong options on the cmd line.
    sys.exit(usage)

#################

if options and options[0][0] not in ['-f','-F']:

    #print options

    # Make sure cmd line looks exactly like this:
    # Find_SSNs -p|-P /path -o|-O /path -t|-T report_type -s|-S|-c|-C|-a|-A

    if len(options) < 4:
        sys.exit(usage)

    if options[0][0] not in ['-p', '-P']:
        sys.exit(usage)

    if options[1][0] not in ['-o', '-O']:
        sys.exit(usage)

    if options[2][0] not in ['-t', '-T']:
        sys.exit(usage)

    if options[3][0] not in ['-s', '-S', '-c', '-C', '-a', '-A']:
        sys.exit(usage)

    for o,a in options:
	if o in "-e":
	    gv.encrypt = True
        elif o in "-v":
            gv.noise = True

    mode = 'nogui'

    # Test the search path to ensure it is valid.
    if os.path.isdir(options[0][1].strip()):
        # It's a good path, but can this user read it?
        if os.access(options[0][1].strip(), os.R_OK):
            search_path = options[0][1].strip()
        else:
            sys.exit("You cannot read '%s'" % options[0][1].strip())
    else:
        sys.exit("'%s' is not a valid path." % options[0][1].strip())

    # Test the output path to ensure it is valid.
    if os.path.isdir(options[1][1].strip()):
        # It's a good path, but can this user write to it?
        if os.access(options[1][1].strip(), os.W_OK):
            path_to_results = options[1][1].strip()
            gv.path_to_results = path_to_results
        else:
            sys.exit("You cannot write to '%s'" % options[1][1].strip())
    else:
        sys.exit("'%s' is not a valid path." % options[1][1].strip())

    # Determine report_type
    if options[2][1].lower() == 'html':
        report_type = 'html'
    elif options[2][1].lower() == 'csv':
        report_type = 'csv'
    else:
        sys.exit("-t may only be 'html' or 'csv' you entered '%s'" %options[2][1])
        

    # Determine what they wish to search for
    if options[3][0].lower() == '-s':
        search_for = 0
        ns, sfv = numbers.numbs(search_for)
    if options[3][0].lower() == '-c':
        search_for = 1
        ns, sfv = numbers.numbs(search_for)
    if options[3][0].lower() == '-a':
        search_for = 2
        ns, sfv = numbers.numbs(search_for)

    # Get the password if we're encrypting
    while gv.encrypt:
	key = getpass.getpass("Enter output encryption password: ")
	key1 = getpass.getpass("Enter the same password again: ")
	if key == key1:
		gv.key = key
		break
	print "Sorry - the passwords do not match."
	
    user.wait(mode)

#########################

else:
    mode = 'gui'
    print "Find_SSNs... Do not close this window."
    user.wait(mode)
    if options and options[0][0] == "-f":
        search_for = 2
        report_type = 'html'
    else:
        search_for = user.search_for(mode)
        report_type = user.report_type(mode)
    gv.key = user.get_encrypt_key(mode)
    if gv.key:
	gv.encrypt = True
    if options and options[0][0] == "-f":
        homedir = os.environ['HOME'];
	searchch = user.simple_scan_type(mode)
	if searchch == "home":
	    search_path = homedir
        if searchch == "all":
            search_path = "/"
        if searchch == "custom":
            search_path = user.input_folder(mode)
        if os.access(homedir,os.R_OK):
            path_to_results = os.path.join(homedir,".find_ssns")
	    if not os.access(path_to_results,os.F_OK):
                os.mkdir(path_to_results)	
        else:
            search_path = user.input_folder(mode)
            path_to_results = user.output_folder(mode)
    else:
        search_path = user.input_folder(mode)
        path_to_results = user.output_folder(mode)
    gv.path_to_results = path_to_results
    ns, sfv = numbers.numbs(search_for)

#########################

ag = numbers.ssns(mode)
cs = numbers.ccns()



user.proceed(search_path, mode)

create.files(path_to_results, report_type)

the_files, ms = targets.files(search_path, skip.file_extensions(), skip.files(), skip.folders(), skip.paths(), path_to_results, mode)

hunt.go(cs, ag, ms, search_path, report_type, skip.numbers(), the_files, path_to_results, ns, sfv, mode)

user.end(report_type, path_to_results, mode)
