############################################################
# Part of the 
# viewer and editor for results from Find_SSNs software (versions that
# produce XML output)
#
# Copyright (c) 2009 Steve Gaarder
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#   $Id: actions.py,v 1.4 2011/04/05 19:08:46 gaarder Exp $
############################################################

import os
import os.path
import subprocess
import gv
import random
import sys

havemac = True
try:
    import macostools
except ImportError:
    havemac = False

gpg_recipients = []


def getaline(fd):
    buff = []
    gotnl = False
    while True:
        c = fd.read(1)
        if c == "":
            break
        buff.append(c)
        if c == '\r' or c == '\n':
            break
    buf = "".join(buff)
    return buf

def redact(fpath,pats,subs):
    
        # generate a name for the output file and make sure it doesn't exist
        outname = fpath 
        while os.path.exists(outname):
            randnum = random.randrange(1,1000,1)
            outname = fpath + str(randnum)

        #On the Mac, Make the new file a copy of the old one, so we get its resource fork.
        if havemac:
            macostools.copy(fpath,outname)
        fin = open(fpath,"rb")
                
        fout = open(outname,"wb")
                
        line = getaline(fin)
        while line:
                for i in range(len(pats)):
                    try:
                        line = line.replace(pats[i],subs[i])
                    except UnicodeDecodeError:
                        pass
                fout.write(line)
                line = getaline(fin)
                        
        fin.close()
        fout.close()
                
        # now see if the size is right
            
        insize = os.path.getsize(fpath)
        outsize = os.path.getsize(outname)
            
        if outsize >= insize and outsize <= insize+2:
                os.remove(fpath)
                os.rename(outname, fpath)
                print "File successfully redacted."
        else:
                print "Error - file not replaced."
    

def quar(path,qdir):
    if os.path.exists(path):
        bname = os.path.basename(path)
        dest = os.path.join(qdir,bname)
        while os.path.exists(dest):
            randnum = random.randrange(1,1000,1)
            dest = os.path.join(qdir, str(randnum) + bname)
        return(os.rename(path,dest))
    
def encrypt(path):
    if gv.have_gpg:
        args = ["gpg", "-e", "-a", "-v", "--yes", "--trust-model", "always"]
        for recip in gpg_recipients:
            args.extend(["-r",recip])
        args.append(path)
        retval = subprocess.call(args)
        if retval == 0:
            return delete(path)
        else:
            return retval
    else:
        print "ERROR: GPG not found"
        return -1
    
def delete(path):
    if gv.have_shred:
        print "Shredding", path
        return subprocess.call(["shred", "-u", "-f", path])
    elif gv.have_rm:
        print "Deleting", path
        return subprocess.call(["rm", "-f", path])
    else:
        print "Deleting", path
        return os.remove(path)

def checkapps():
    f=open(os.devnull,"w")
    try:
        subprocess.call(["gpg", "--version"],stderr=f,stdout=f)
    except Exception:
        print "Gpg is not installed; encryption will not work!\n";
        gv.have_gpg = False
    else:
        gv.have_gpg = True
        
    try:
        subprocess.call(["shred", "--version"],stderr=f,stdout=f)
    except Exception:
        gv.have_shred = False
    else:
        gv.have_shred = True

    try:
        subprocess.call(["rm","--version"],stderr=f,stdout=f)
    except Exception:
        gv.have_rm = False
    else:
        gv.have_rm = True
        
    f.close()

    if os.path.exists("gpg_recipients"):
        f = open("gpg_recipients","r")
        try:
            for line in f:
                line = str.strip(line)
                if len(line) > 0:
                    gpg_recipients.append(line)
        finally:
            f.close()
                
            
