# Copyright (c) 2004 - 2008 16 Systems, LLC
# Copyright (c) 2009 Virginia Polytechnic Institute and State University
# All rights reserved.
#
# License & Redistribution Information
# http://www.security.vt.edu/Find_SSNs/find_ssns_license.html


import os
import os.path


# The win32 imports will silently fail on non-Windows Systems
try:
    import win32api
    import win32con
except:
    pass

encrypt = False

def files(path_to_results, report_type):
    
    # Names of output files that Find_SSNs will create.
    file_list = ['.Find_SSNs_exceptions.txt', '.Find_SSNs_skip.txt', 'Find_SSNs.xml', 'Find_SSNs.%s' %report_type]
    
    for f in file_list:
        # Try to make the files normal (if they alreay exist) on win systems.
        try:
            win32api.SetFileAttributes(os.path.join(path_to_results, f), win32con.FILE_ATTRIBUTE_NORMAL)
        except:
            pass

        # Create the files. This overwrites existing files!
        create = open(os.path.join(path_to_results, f), 'w')
        create.close()

        if '.Find_SSNs' in f:
            # Try to make the files that begin with a dot hidden on windows systems.
            try:
                win32api.SetFileAttributes(os.path.join(path_to_results, f), win32con.FILE_ATTRIBUTE_HIDDEN)
            except:
                pass

    return file_list
