# Copyright (c) 2004 - 2008 16 Systems, LLC
# Copyright (c) 2009 Virginia Polytechnic Institute and State University
# All rights reserved.
#
# License & Redistribution Information
# http://www.security.vt.edu/Find_SSNs/find_ssns_license.html


import re
import socket
import sys
import urllib
# Local Imports
import version


def numbs(search_for):

    # Return (Regex and search for value) for report

    # We are only looking for strings like this:

    # 1. nnnnnnnnn 'nnn-nn-nnnn' 'nnn nn nnnn'  SSN
    # 2. n(13,16) with dashes or spaces anywhere CCN

    # Search only SSNs
    if search_for == 0:
        nums = re.compile(r'\b\d{9}\b|\b\d{3}-\d{2}-\d{4}\b|\b\d{3} \d{2} \d{4}\b')
        search_for_value = 'SSNs'
        return (nums, search_for_value)

    # Search CCNs and SSNs
    if search_for == 1:
#        nums = re.compile(r'\b(?:\d[ -]*){13,16}\b')
        nums = re.compile(r'\b\d{9}\b|\b\d{3}-\d{2}-\d{4}\b|\b\d{3} \d{2} \d{4}\b|\b(?:\d[ -]*){13,16}\b')
        search_for_value = 'SSNs + CCNs'
        return (nums, search_for_value)

    # Search all regexs
    if search_for == 2:
        nums = re.compile(r'\b\d{9}\b|\b\d{3}-\d{2}-\d{4}\b|\b\d{3} \d{2} \d{4}\b|\b(?:\d[ -]*){13,16}\b|\b(?:acct|account)\b.{0,64}(?:\d[ -]*){5,16}\b',re.IGNORECASE)
        search_for_value = 'SSNs + CCNs + ANs'
        return (nums, search_for_value)


def ccns():
    
    # Load credit card number information into a dictionary. Can be expanded to cover other credit cards so
    # long as the prefix is 1, 2, 3 or 4 digits in length.

    # card_prefix: [card_length, card_type]

    card_info = {}
    card_info['1800'] = [15, "JCB"]
    card_info['2131'] = [15, "JCB"]
    card_info['300'] = [14, "Diners CB"]
    card_info['301'] = [14, "Diners CB"]
    card_info['302'] = [14, "Diners CB"]
    card_info['303'] = [14, "Diners CB"]
    card_info['304'] = [14, "Diners CB"]
    card_info['305'] = [14, "Diners CB"]
    card_info['34'] = [15, "Amex"]
    card_info['35'] = [16, "JCB"]
    card_info['36'] = [14, "Diners Intl"]
    card_info['37'] = [15, "Amex"]
    card_info['385'] = [14, "Diners CB"]
    # Visa is a unique case
    card_info['4'] = [[13,16], "Visa"]
    card_info['51'] = [16, "MC"]
    card_info['52'] = [16, "MC"]
    card_info['53'] = [16, "MC"]
    card_info['54'] = [16, "MC"]
    card_info['55'] = [16, "MC or Diners US and CA"]
    card_info['6011'] = [16, "Discover"]
    card_info['65'] = [16, "Discover"]
    #print card_info
    return card_info


def ssns(mode):

    if mode == 'gui':
        import wx

    # Download the current areas to groups file and load it into a dictionary.

    socket.setdefaulttimeout(10)

    try:
        fp = urllib.urlopen("http://www.security.vt.edu/Find_SSNs/areas_groups.txt")
        lines = fp.readlines()
        fp.close()

        ag = {}
        for line in lines:
            line = line.strip().split()
            a,g = line[0], line[1]
            ag[a] = g

        #print ag
        #print len(ag)
        return ag
    except:
        if mode == 'nogui':
            sys.exit("Error - Cannot load SSA areas to groups information. Are you connected to the Internet?")
        else:
            app = wx.PySimpleApp()
            app.MainLoop()
            wx.MessageBox("Cannot load SSA areas to groups information. Are you connected to the Internet?", 'Find_SSNs %s - Error' %version.numb, wx.ICON_ERROR)
            sys.exit()
