############################################################
# Copyright (c) 2009 Steve Gaarder
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>
############################################################
import wx
import sha

class LoginDialog(wx.Dialog):
    def __init__(self, parent, id=-1, title="Login", message="Enter Password",
                 pos=wx.DefaultPosition,
                 size=wx.Size(350, 150)):
        wx.Dialog.__init__(self, parent, id, title, pos, size)
        wx.StaticText(self, -1, message,
                     wx.Point(15, 5))
        wx.StaticText(self, -1, 'Password: ', wx.Point(20, 55))
        self.passwordBox = wx.TextCtrl(self, -1, '', wx.Point(85,55),
                                 wx.Size(200, -1), style=wx.TE_PASSWORD)
        wx.Button(self, wx.ID_OK,     ' OK ', wx.Point(35, 90),
                 wx.DefaultSize).SetDefault()
        wx.Button(self, wx.ID_CANCEL, ' Cancel ', wx.Point(135, 90),
                 wx.DefaultSize)

    def GetPassword(self):
        val = self.ShowModal()
        if val == wx.ID_OK:
            password = self.passwordBox.GetValue()
            return password
        else:
            return None
