############################################################
# Viewer and editor for results from Find_SSNs software (versions that
# produce XML output)
#
# Copyright (c) 2009 Steve Gaarder
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#   $Id: resview.py,v 1.14 2011/06/23 17:44:59 gaarder Exp $
############################################################


import wx
import os
import sys
import base64
import StringIO
import re
from xml.dom import minidom, Node

from passworddialog import LoginDialog
from blowfish import Blowfish
import detailsfile
import actions
import gv

ID_ABOUT=101
ID_OPEN=102
ID_SAVEAS=103
ID_SAVESKIP=104
ID_DOENCRYPT=105
ID_DOQUAR=110
ID_DOREDACT=112
ID_DODELETE=106
ID_SAVEREPORT=107
ID_SAVE=108
ID_SAVEALL=109
ID_BUTTON1=150
ID_EXIT=200
ID_TREE=300
buttontext = []
buttontext.append("Next")
buttontext.append("Mark Ignore")
buttontext.append("Mark Encrypt")
buttontext.append("Mark Quarantine")
buttontext.append("Mark Redact")
buttontext.append("Mark Delete")
buttontext.append("Unmark")
buttontext.append("Previous")
labelcolor = {}
labelcolor["delete"] = "red"
labelcolor["ignore"] = "dark green"
labelcolor["encrypt"] = "blue"
labelcolor["quar"] = "#005588"
labelcolor["redact"] = "#999900"
labelcolor["normal"] = "black"

changemade = False

def getText(nodelist):
        rc = ""
        for node in nodelist:
            if node.nodeType == node.TEXT_NODE:
                            rc = rc + node.data
        return rc
                            
class MainWindow(wx.Frame):
    def fixselection(self):
	    # Make sure that a file node is selected
	    me = self.tree.GetSelection()
	    mom =  self.tree.GetItemParent(me)
	    # Check if we're at the root
	    if mom:
		    # make sure our parent is the root
		    while self.tree.GetItemParent(mom):
			    me = mom
			    mom = self.tree.GetItemParent(me)
	    else:
		    me, treecookie = self.tree.GetFirstChild(me)
	    self.tree.SelectItem(me)

    def gotonext(self,theitem):
	    nextitem = self.tree.GetNextSibling(theitem)
	    if nextitem:
		    self.tree.SelectItem(nextitem,True)
		    self.tree.Collapse(theitem)
		    self.tree.Expand(nextitem)
		    firstmatch, treecookie = self.tree.GetFirstChild(nextitem)
		    self.tree.Expand(firstmatch)
		    
    def gotoprev(self,theitem):
	    previtem = self.tree.GetPrevSibling(theitem)
	    if previtem:
		    self.tree.SelectItem(previtem,True)
		    self.tree.Collapse(theitem)
		    self.tree.Expand(previtem)
		    firstmatch, treecookie = self.tree.GetFirstChild(previtem)
		    self.tree.Expand(firstmatch)
		    
    def loadfile(self,filename):
        dfp = open(filename,'r')
	fline = dfp.readline()
	gv.key = ""
	if fline.find("-----BEGIN BLOWFISH CTR-----") != -1:
		fline = dfp.readline()
		salt = str.strip(fline)[5:]
		passd = LoginDialog(self,message="Please enter the decryption password")
		gv.key = passd.GetPassword()
		gv.encrypt = True
		ckey = gv.key + salt
		cipher = Blowfish (ckey)
		cipher.initCTR()
		cleartext = ""
		for fline in dfp:
			cleartext += cipher.decryptCTR(base64.b64decode(fline))
		dfp.close()
		if cleartext.startswith("<document>"):
			doc = minidom.parseString(cleartext)
		else:
			wx.MessageBox("The password was incorrect.  Exiting.","Sorry")
			sys.exit()
        else:
		dfp.close()
		pdialog = wx.ProgressDialog ('Find_SSNs', 'Reading File...',maximum=1000)
		pdialog.Update(999,"Reading File...")
		doc = minidom.parse(filename)
		pdialog.Update(1,"Formatting Data...")
		pdialog.Destroy()
	self.doc = doc
        docnode = doc.documentElement
        for filenode in docnode.getElementsByTagName("file"):
            filepath = filenode.getElementsByTagName("name")[0]
            self.fileroot = self.tree.AppendItem(self.treeroot,getText(filepath.childNodes))
	    self.tree.SetPyData(self.fileroot,filenode)
	    actionnodes = filenode.getElementsByTagName('action')
	    if actionnodes:
		    fileaction = getText(actionnodes[0].childNodes)
		    self.tree.SetItemTextColour(self.fileroot,labelcolor[fileaction])
	    for match in filenode.getElementsByTagName("match"):
		    matchdata = getText(match.getElementsByTagName("data")[0].childNodes)
		    self.matchitem = self.tree.AppendItem(self.fileroot,"MATCH: " + matchdata)
		    for detail in match.childNodes:
			    if detail.nodeType == detail.ELEMENT_NODE and detail.nodeName != "data":
				    if detail.nodeName == "subject":
					    detailtext = getText(detail.childNodes)
				    else:
					    detailtext = detail.nodeName + ": " + getText(detail.childNodes)
				    detailitem = self.tree.AppendItem(self.matchitem,detailtext)

        # Expand the nodes so everything is visible initially
        self.tree.Expand(self.treeroot)
	firstitem, treecookie = self.tree.GetFirstChild(self.treeroot)
	if firstitem.IsOk():
		self.tree.SelectItem(firstitem, True)
		self.tree.Expand(firstitem)
		firstmatch, treecookie = self.tree.GetFirstChild(firstitem)
		self.tree.Expand(firstmatch)
	else:
		wx.MessageBox("No potentially sensitive numbers were found.","Nothing Found")
		
    def __init__(self,parent,id,title):
        self.dirname=''
	actions.checkapps()
        wx.Frame.__init__(self,parent,wx.ID_ANY, title)
        self.control = wx.TextCtrl(self, 1, style=wx.TE_MULTILINE)
	self.tree = wx.TreeCtrl(self, ID_TREE)
 # Add a root node to the wxTreeCtrl.
        self.treeroot = self.tree.AddRoot('Sensitive Data')
	if len(sys.argv) > 1:
		self.loadfile(sys.argv[1])
		self.dirname = os.path.abspath(os.path.dirname(sys.argv[1]))
	else:
		self.doc = None
        self.CreateStatusBar() # A Statusbar in the bottom of the window
        # Setting up the menu.
        filemenu= wx.Menu()
        filemenu.Append(ID_OPEN, "&Open"," Open a file to edit")
        filemenu.Append(ID_SAVE, "&Save"," Save file")
        filemenu.Append(ID_SAVEAS, "&Save As"," Save to a file")
        filemenu.Append(ID_SAVESKIP, "&Save Skip File"," Save to a skip file")
        filemenu.Append(ID_SAVEREPORT, "&Save Report File"," Save to a report file")
        filemenu.Append(ID_SAVEALL, "&Save All"," Save file, skip, and report")
        filemenu.AppendSeparator()
        filemenu.Append(ID_ABOUT, "&About"," Information about this program")
        filemenu.AppendSeparator()
        filemenu.Append(ID_EXIT,"E&xit"," Terminate the program")
        actionmenu= wx.Menu()
        actionmenu.Append(ID_DOENCRYPT, "&Encrypt files marked as encrypt"," Encrypt the files that are so marked")
        actionmenu.Append(ID_DOQUAR, "&Quarantine files marked as quarantine"," Move the files that are so marked to the quarantine directory")
        actionmenu.Append(ID_DOREDACT, "&Redact files marked as redact"," Edit the files to change digits in sensitive data to X")
        actionmenu.Append(ID_DODELETE, "&Delete files marked as delete"," Delete the files that are so marked")
        # Creating the menubar.
        menuBar = wx.MenuBar()
        menuBar.Append(filemenu,"&File") # Adding the "filemenu" to the MenuBar
        menuBar.Append(actionmenu,"&Actions") # Adding the "filemenu" to the MenuBar
        self.SetMenuBar(menuBar)  # Adding the MenuBar to the Frame content.
        wx.EVT_MENU(self, ID_ABOUT, self.OnAbout)
        wx.EVT_MENU(self, ID_EXIT, self.OnExit)
        wx.EVT_MENU(self, ID_OPEN, self.OnOpen)
        wx.EVT_MENU(self, ID_SAVE, self.OnSave)
        wx.EVT_MENU(self, ID_SAVEAS, self.OnSaveAs)
        wx.EVT_MENU(self, ID_SAVEALL, self.OnSaveAll)
        wx.EVT_MENU(self, ID_SAVESKIP, self.OnSaveSkip)
        wx.EVT_MENU(self, ID_SAVEREPORT, self.OnSaveReport)
        wx.EVT_MENU(self, ID_DOENCRYPT, self.OnDoEncrypt)
        wx.EVT_MENU(self, ID_DOQUAR, self.OnDoQuar)
        wx.EVT_MENU(self, ID_DOREDACT, self.OnDoRedact)
        wx.EVT_MENU(self, ID_DODELETE, self.OnDoDelete)
        self.sizer2 = wx.BoxSizer(wx.HORIZONTAL)
        self.buttons=[]
        for i in range(0,8):
            self.buttons.append(wx.Button(self, ID_BUTTON1+i, buttontext[i]))
            self.sizer2.Add(self.buttons[i],1,wx.EXPAND)
        self.buttons[1].Bind(wx.EVT_BUTTON,self.OnIgnoreButton)
	self.buttons[1].SetForegroundColour(labelcolor["ignore"])
        self.buttons[2].Bind(wx.EVT_BUTTON,self.OnEncryptButton)
	self.buttons[2].SetForegroundColour(labelcolor["encrypt"])
        self.buttons[3].Bind(wx.EVT_BUTTON,self.OnQuarButton)
	self.buttons[3].SetForegroundColour(labelcolor["quar"])
        self.buttons[4].Bind(wx.EVT_BUTTON,self.OnRedactButton)
	self.buttons[4].SetForegroundColour(labelcolor["redact"])
        self.buttons[5].Bind(wx.EVT_BUTTON,self.OnDelButton)
	self.buttons[5].SetForegroundColour(labelcolor["delete"])
        self.buttons[6].Bind(wx.EVT_BUTTON,self.OnNoActButton)
	self.buttons[6].SetForegroundColour(labelcolor["normal"])
        self.buttons[7].Bind(wx.EVT_BUTTON,self.OnPrevButton)
        self.buttons[0].Bind(wx.EVT_BUTTON,self.OnNextButton)
        # Use some sizers to see layout options
        self.sizer=wx.BoxSizer(wx.VERTICAL)
        # self.sizer.Add(self.control,1,wx.EXPAND)
        self.sizer.Add(self.tree,1,wx.EXPAND)
        self.sizer.Add(self.sizer2,0,wx.EXPAND)
        #Layout sizers
        self.SetSizer(self.sizer)
        self.SetAutoLayout(1)
        self.sizer.Fit(self)
        self.Show(1)
    def SetNodeDone(self, node, action):
	    newnode = self.doc.createElement("done")
	    textnode = self.doc.createTextNode(action)
	    existing_nodes = node.getElementsByTagName("done")
	    for n in existing_nodes:
		    node.removeChild(n)
		    n.unlink()
	    newnode.appendChild(textnode)
	    node.appendChild(newnode)
    def SetNodeAction(self, node, action):
	    global changemade
	    newnode = self.doc.createElement("action")
	    textnode = self.doc.createTextNode(action)
	    existing_nodes = node.getElementsByTagName("action")
	    for n in existing_nodes:
		    node.removeChild(n)
		    n.unlink()
	    newnode.appendChild(textnode)
	    node.appendChild(newnode)
	    changemade = True
    def UnsetNodeAction(self, node):
	    existing_nodes = node.getElementsByTagName("action")
	    for n in existing_nodes:
		    node.removeChild(n)
		    n.unlink()
    def OnIgnoreButton(self,e):
	    self.fixselection()
	    selitem =  self.tree.GetSelection()
            selected = self.tree.GetItemText(selitem)
	    self.tree.SetItemTextColour(selitem,labelcolor["ignore"])
	    xmlnode = self.tree.GetPyData(selitem)
	    self.SetNodeAction(xmlnode,"ignore")
	    self.gotonext(selitem)
    def OnNoActButton(self,e):
	    self.fixselection()
	    selitem =  self.tree.GetSelection()
            selected = self.tree.GetItemText(selitem)
	    self.tree.SetItemTextColour(selitem,labelcolor["normal"])
	    xmlnode = self.tree.GetPyData(selitem)
	    self.UnsetNodeAction(xmlnode)
	    self.gotonext(selitem)
    def OnEncryptButton(self,e):
	    selitem =  self.tree.GetSelection()
            selected = self.tree.GetItemText(selitem)
	    self.tree.SetItemTextColour(selitem,labelcolor["encrypt"])
	    xmlnode = self.tree.GetPyData(selitem)
	    self.SetNodeAction(xmlnode,"encrypt")
	    self.gotonext(selitem)

    def OnQuarButton(self,e):
	    selitem =  self.tree.GetSelection()
            selected = self.tree.GetItemText(selitem)
	    self.tree.SetItemTextColour(selitem,labelcolor["quar"])
	    xmlnode = self.tree.GetPyData(selitem)
	    self.SetNodeAction(xmlnode,"quar")
	    self.gotonext(selitem)

    def OnRedactButton(self,e):
	    selitem =  self.tree.GetSelection()
            selected = self.tree.GetItemText(selitem)
	    xmlnode = self.tree.GetPyData(selitem)
	    type_nodes = xmlnode.getElementsByTagName("type")
	    if len(type_nodes) > 0:
		    filetype = getText(type_nodes[0].childNodes)
	    else:
		    filetype = ""
	    if filetype == "" or filetype == "text" or filetype == "mbox" or filetype == "emlx":
		    self.tree.SetItemTextColour(selitem,labelcolor["redact"])
		    self.SetNodeAction(xmlnode,"redact")
		    self.gotonext(selitem)
	    else:
		    wx.MessageBox("This type of file (%s) cannot be redacted." % filetype,"Sorry")

    def OnDelButton(self,e):
	    selitem =  self.tree.GetSelection()
            selected = self.tree.GetItemText(selitem)
	    self.tree.SetItemTextColour(selitem,labelcolor["delete"])
	    xmlnode = self.tree.GetPyData(selitem)
	    self.SetNodeAction(xmlnode,"delete")	    
	    self.gotonext(selitem)

    def OnNextButton(self,e):
	    selitem =  self.tree.GetSelection()
	    self.gotonext(selitem)
    def OnPrevButton(self,e):
	    selitem =  self.tree.GetSelection()
	    self.gotoprev(selitem)

    def OnAbout(self,e):
        selitem =  self.tree.GetSelection()
	xmlnode = self.tree.GetPyData(selitem)
	name_node = xmlnode.getElementsByTagName("name")[0]
	node_name = getText(name_node.childNodes)
	print node_name

        d= wx.MessageDialog( self, "Current file: " + node_name,"Results Viewer/editor", wx.OK)
                            # Create a message dialog box
        d.ShowModal() # Shows it
        d.Destroy() # finally destroy it when finished.
    def OnExit(self,e):
        global changemade
        if changemade:
		xdi = wx.MessageDialog(None,"Do you want to save your changes?","Save changes",wx.YES_NO)
		if xdi.ShowModal() == wx.ID_YES:
			self.filename = "skip_paths.txt"
			self.SaveSkip("a")
			self.filename = "Find_SSNs.xml"
			self.SaveFile()
			self.filename = "Find_SSNs_report.csv"
			self.SaveReport()
		xdi.Destroy()
        self.Close(True)  # Close the frame.
    def OnOpen(self,e):
        """ Open a file"""
        dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", "*.*", wx.OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            self.filename=dlg.GetFilename()
            self.dirname=dlg.GetDirectory()
            self.loadfile(os.path.join(self.dirname, self.filename))
        dlg.Destroy()
    def OnSave(self,e):
	    self.filename = "Find_SSNs.xml"
	    self.SaveFile()
	    
    def OnSaveAll(self,e):
	    global changemade
	    self.filename = "skip_paths.txt"
	    self.SaveSkip("a")
	    self.filename = "Find_SSNs.xml"
	    self.SaveFile()
	    self.filename = "Find_SSNs_report.csv"
	    self.SaveReport()
	    changemade = False
	    
    def OnSaveAs(self,e):
        """ Save a file"""
        dlg = wx.FileDialog(self, "Choose a file", self.dirname, "Find_SSNs.xml", "*.*", wx.SAVE)
        if dlg.ShowModal() == wx.ID_OK:
            self.filename=dlg.GetFilename()
            self.dirname=dlg.GetDirectory()
	    self.SaveFile()
        dlg.Destroy()
    def SaveFile(self):
	    if gv.key == "":
		    f=open(os.path.join(self.dirname, self.filename),'w')
		    self.doc.writexml(f)
		    f.close()
	    else:
		    sf = StringIO.StringIO()
		    self.doc.writexml(sf)
		    sf.seek(0)
		    detailsfile.dopen(self.dirname, self.filename)
		    for line in sf:
			    detailsfile.dput(line.encode('utf8'))
		    detailsfile.dclose()
		    sf.close()
	    
    def OnSaveSkip(self,e):
        """ Save a skip file"""
        dlg = wx.FileDialog(self, "Choose a file", self.dirname, "skip_paths.txt", "*.*", wx.SAVE)
        if dlg.ShowModal() == wx.ID_OK:
            self.filename=dlg.GetFilename()
            self.dirname=dlg.GetDirectory()
	    openmode = "a"
	    if os.path.exists(os.path.join(self.dirname, self.filename)):
		    md = wx.MessageDialog(self, "Overwrite the existing data? (selecting NO will add to it)", "File exists", wx.YES_NO)
		    response =  md.ShowModal()
		    if response == wx.ID_YES:
			    openmode = "w"
		    md.Destroy()
	    self.SaveSkip(openmode)
        dlg.Destroy()
    def SaveSkip(self,openmode):
	    f=open(os.path.join(self.dirname, self.filename),openmode)
	    actionnodes = self.doc.getElementsByTagName("action")
	    for a in actionnodes:
		    pnode = a.parentNode
		    if getText(a.childNodes) == "ignore":
			    name_node = pnode.getElementsByTagName("name")[0]
			    node_name = getText(name_node.childNodes)
			    print>> f, node_name
			    self.SetNodeDone(pnode,"ignore")
	    f.close()
	    
    def OnSaveReport(self,e):
        dlg = wx.FileDialog(self, "Choose a file", self.dirname, "Find_SSNs_report.csv", "*.*", wx.SAVE)
        if dlg.ShowModal() == wx.ID_OK:
            self.filename=dlg.GetFilename()
            self.dirname=dlg.GetDirectory()
	    self.SaveReport()
	    
	dlg.Destroy()
    def SaveReport(self):
	    self.acount = dict(ignore=0, encrypt=0, delete=0, redact=0, quar=0)
	    self.dcount = dict(ignore=0, encrypt=0, delete=0, redact=0, quar=0)
	    openmode = "w"
	    f=open(os.path.join(self.dirname, self.filename),openmode)
	    actionnodes = self.doc.getElementsByTagName("action")
	    for a in actionnodes:
		    pnode = a.parentNode
		    self.acount[getText(a.childNodes)] = self.acount[getText(a.childNodes)] + 1
	    actionnodes = self.doc.getElementsByTagName("done")
	    for a in actionnodes:
		    pnode = a.parentNode
		    self.dcount[getText(a.childNodes)] = self.dcount[getText(a.childNodes)] + 1

	    filenodes = self.doc.getElementsByTagName("file")
	    print >>f, "Files," + str(len(filenodes))
	    unmarked = len(filenodes) - sum(self.acount.values())
	    print >>f, "Unmarked," + str(unmarked)
	    undone = len(filenodes) - sum(self.dcount.values())
	    print >>f, "Undone," + str(undone)
	    print >>f, "MarkIgnore" + "," + str(self.acount["ignore"])
	    print >>f, "DoneIgnore" + "," + str(self.dcount["ignore"])
	    print >>f, "MarkEncrypt" + "," + str(self.acount["encrypt"])
	    print >>f, "DoneEncrypt" + "," + str(self.dcount["encrypt"])
	    print >>f, "MarkDelete" + "," + str(self.acount["delete"])
	    print >>f, "DoneDelete" + "," + str(self.dcount["delete"])
	    print >>f, "MarkQuar" + "," + str(self.acount["quar"])
	    print >>f, "DoneQuar" + "," + str(self.dcount["quar"])
	    print >>f, "MarkRedact" + "," + str(self.acount["redact"])
	    print >>f, "DoneRedact" + "," + str(self.dcount["redact"])
	    f.close()
    
    def OnDoEncrypt(self,e):
	    actionnodes = self.doc.getElementsByTagName("action")
	    for a in actionnodes:
		    pnode = a.parentNode
		    if getText(a.childNodes) == "encrypt":
			    name_node = pnode.getElementsByTagName("name")[0]
			    node_name = getText(name_node.childNodes)
			    actions.encrypt(node_name)
			    self.SetNodeDone(pnode,"encrypt")

    def OnDoQuar(self,e):
        count = 0
        dlg = wx.DirDialog(self, "Choose Quarantine Directory", self.dirname, wx.DD_DEFAULT_STYLE)
        if dlg.ShowModal() == wx.ID_OK:
            qdirname=dlg.GetPath()
	    actionnodes = self.doc.getElementsByTagName("action")
	    for a in actionnodes:
		    pnode = a.parentNode
		    if getText(a.childNodes) == "quar":
			    name_node = pnode.getElementsByTagName("name")[0]
			    node_name = getText(name_node.childNodes)
			    actions.quar(node_name,qdirname)
			    self.SetNodeDone(pnode,"quar")
			    count = count + 1

        dlg.Destroy()
	print count, "files quarantined."

    def OnDoRedact(self,e):
	    matches = []
	    actionnodes = self.doc.getElementsByTagName("action")
	    for a in actionnodes:
		    pnode = a.parentNode
		    if getText(a.childNodes) == "redact":
			    matches = []
			    name_node = pnode.getElementsByTagName("name")[0]
			    node_name = getText(name_node.childNodes)
			    for match in pnode.getElementsByTagName("match"):
				    matchdata = getText(match.getElementsByTagName("data")[0].childNodes)
				    if matchdata not in matches:
					    matches.append(matchdata)
			    pats = []
			    subs = []
			    choicewin = wx.MultiChoiceDialog(None,node_name,"Choose numbers, then click OK to redact, Cancel to leave alone",matches)
			    selall = range(len(matches))
			    choicewin.SetSelections(selall)
			    answer = choicewin.ShowModal()
			    selected = choicewin.GetSelections()
			    choicewin.Close(True)    
			    choicewin.Destroy()
			    if answer == wx.ID_OK:
				    print node_name
				    for m in selected:
					    pats.append(matches[m].rstrip())
					    subs.append(re.sub(r'\d','X',matches[m].rstrip()))
				    for i in range(len(pats)):
					    print pats[i], subs[i]

					    
				    actions.redact(node_name,pats,subs)
				    self.SetNodeDone(pnode,"redact")

    def OnDoDelete(self,e):
	    actionnodes = self.doc.getElementsByTagName("action")
	    for a in actionnodes:
		    pnode = a.parentNode
		    if getText(a.childNodes) == "delete":
			    name_node = pnode.getElementsByTagName("name")[0]
			    node_name = getText(name_node.childNodes)
			    actions.delete(node_name)
			    self.SetNodeDone(pnode,"delete")

app = wx.PySimpleApp()
frame = MainWindow(None, -1, "Results editor")
app.MainLoop()
