# Copyright (c) 2004 - 2008 16 Systems, LLC
# Copyright (c) 2009 Virginia Polytechnic Institute and State University
# All rights reserved.
#
# License & Redistribution Information
# http://www.security.vt.edu/Find_SSNs/find_ssns_license.html


import os
import os.path

import gv

def file_extensions():

    # Returns a list of file extensions to skip. Pass this list to the target module.

    ext_skip_list = []

    # Add file extensions that you don't want scanned here (all lower case):
    #
    # Note: If you wish to scan pdf files, remove 'pdf' from this list and
    # follow the instructions here: http://security.vt.edu/Find_SSNs/pdf.html
    extensions = ['a', 'aac', 'api', 'arx', 'au', 'avi', 'ax', 'bin', 'bmp',
                  'c', 'cab', 'cache', 'com', 'config', 'cpl', 'deb', 'dectest', 'dll', 'dmp',
                  'eps', 'exe', 'fon', 'gif', 'gz', 'h', 'ico', 'inf', 'ini', 'iso', 'jar', 'jpeg', 'jpg', 'js',
                  'lib', 'lnk', 'm4a', 'm4p', 'manifest', 'mid', 'midi', 'mov', 'mp3', 'mpeg', 'mpg', 'msi',
                  'o', 'obe', 'ocx', 'otf',
                  'pl', 'plist', 'pm', 'png', 'ppd', 'psd', 'pst', 'py', 'pyc', 'pyd', 'pyo', 'pyw',
                  'rb', 'rpm', 'scr', 'so', 'svg', 'svn-base', 'sys',
                  'tar', 'tbl', 'tif', 'tiff', 'ttc', 'ttf', 'upp', 'vmdk', 'vmem',
                  'wav', 'wave', 'wma', 'wmv', 'wmz', 'xpi', 'xpm', 'fig', 'xcf','m']


    # Allow users to add file extensions in a file to be skipped #

    filename = 'skip_extensions.txt'

    if os.path.isfile(filename):
        fp = open(filename)
        user_extensions = fp.readlines()
        fp.close()

        for user_extension in user_extensions:
            # Remove whitespace, dots and make lowercase.
            user_extension = user_extension.strip().strip('.').lower()
            if user_extension:
                extensions.append(user_extension)

        extensions = list(set(extensions))

    else:
        pass

    # End of Allow users to add file extensions in a file to be skipped #

    # Skip .exe
    for ext in extensions:
        ext_skip_list.append('.' + ext)
        #print '.' + ext

    # Skip .ex_
    for ext in extensions:
        if len(ext) == 3:
            #print '.' + ext[0:2] + '_'
            ext_skip_list.append('.' + ext[0:2] + '_')

    ext_skip_list.sort()
    #print ext_skip_list, len(ext_skip_list)
    return ext_skip_list


def files():

    # Returns a list of file names to skip. Pass this list to the target module.

    # Exclude these files from the scan. Add file names you would like excluded here (all lower case):
    file_skip_list = ['.find_ssns_exceptions.txt', 'find_ssns.txt', 'find_ssns.html', 'find_ssns.csv',
                      '.find_ssns_skip.txt', 'maxsize.txt', 'skip_numbers.txt', 'find_ssns_exe.zip',
                      'find_ssns_src.zip', 'find_ssns_exe.zip.sig', 'find_ssns_src.zip.sig', 'Cache.db']

    # Allow users to add file names in a file to be skipped #

    filename = 'skip_files.txt'

    if os.path.isfile(filename):
        fp = open(filename)
        user_files = fp.readlines()
        fp.close()

        for user_file in user_files:
            user_file = user_file.strip().lower()
            if user_file:
                file_skip_list.append(user_file)

        file_skip_list = list(set(file_skip_list))

    else:
        pass

    # End of Allow users to add file names in a file to be skipped #

    file_skip_list.sort()
    #print file_skip_list, len(file_skip_list)
    return file_skip_list


def folders():

    # Returns a list of folder names to skip. Pass this list to the target module.

    # Exclude these folders from the scan. Add folder names you would like excluded here (all lower case):
    folder_skip_list = ['dev', 'proc', 'sys', '.find_ssns','.mozilla','.kde','.gnome','.gnome2','.gconf','.gconf2', '.gconfd', '.nautilus', '.openoffice.org2']

    # Allow users to add folder names to be skipped #

    filename = 'skip_folders.txt'

    if os.path.isfile(filename):
        fp = open(filename)
        user_folders = fp.readlines()
        fp.close()

        for user_folder in user_folders:
            user_folder = user_folder.strip().lower()
            if user_folder:
                folder_skip_list.append(user_folder)

        folder_skip_list = list(set(folder_skip_list))

    else:
        pass

    folder_skip_list.sort()
    #print folder_skip_list, len(folder_skip_list)
    return folder_skip_list


def numbers():

    # Returns a list of numbers to skip. Pass this list to the hunt module.

    # Exclude numbers from the scan. Add numbers you would like excluded here:
    number_skip_list = ['111111111', '222222222', '333333333',
                        '444444444', '555555555', '123456789',
                        '012345678', '393222000']

    # Allow users to add numbers to be skipped #

    filename = 'skip_numbers.txt'

    if os.path.isfile(filename):
        fp = open(filename)
        user_numbers = fp.readlines()
        fp.close()

        for user_number in user_numbers:
            user_number = user_number.strip()
            if user_number:
                number_skip_list.append(user_number)

        number_skip_list = list(set(number_skip_list))

    else:
        pass

    number_skip_list.sort()
    #print number_skip_list, len(number_skip_list)
    return number_skip_list

def paths():

    # Returns a list of paths to skip. Pass this list to the target module.

    path_skip_list = []
    filename = 'skip_paths.txt'

    if os.path.isfile(filename):
        fp = open(filename)
        user_paths = fp.readlines()
        fp.close()

        for user_path in user_paths:
            user_path = user_path.strip().lower()
            if user_path:
                path_skip_list.append(user_path)

    # Also process a file in the results directory
    filename = os.path.join(gv.path_to_results,filename)
    if os.path.isfile(filename):
        fp = open(filename)
        user_paths = fp.readlines()
        fp.close()

        for user_path in user_paths:
            user_path = user_path.strip().lower()
            if user_path:
                path_skip_list.append(user_path)

        path_skip_list = list(set(path_skip_list))

    else:
        pass

    path_skip_list.sort()
    #print path_skip_list, len(path_skip_list)
    return path_skip_list


