# Copyright (c) 2004 - 2008 16 Systems, LLC
# Copyright (c) 2009 Virginia Polytechnic Institute and State University
# All rights reserved.
#
# License & Redistribution Information
# http://www.security.vt.edu/Find_SSNs/find_ssns_license.html

import os
import os.path
import sys
# local imports
import version
from passworddialog import LoginDialog

def input_folder(mode):

    # Folder or drive user wants to search.

    if mode == 'gui':

        import wx

        app = wx.PySimpleApp()
        app.MainLoop()

        td = wx.DirDialog(None, "Find_SSNs %s - Select A Folder To Search" %version.numb, ".", style=wx.DD_DEFAULT_STYLE)
        response = td.ShowModal()
        folder = td.GetPath()
        # Just for WinXP and Older
        if not os.path.isdir(folder):
            wx.MessageBox("The area you selected cannot be searched.\nPlease start again.", 'Find_SSNs %s' %version.numb, wx.ICON_ERROR)
            td.Destroy()
            sys.exit()
        else:            
            #print response
            if response == wx.ID_OK:
                td.Destroy()
                #print folder
                #print type(folder)
                return str(folder)
            else:
                #print "User selected 'cancel' or 'X' in user.input_folder function"
                td.Destroy()
                sys.exit()

    else:
        pass


def output_folder(mode):

    # Folder or drive user wants to write search results to.

    if mode == 'gui':

        import wx

        app = wx.PySimpleApp()
        app.MainLoop()

        td = wx.DirDialog(None, "Find_SSNs %s - Select A Folder To Save Results" %version.numb, ".", style=wx.DD_DEFAULT_STYLE)
        response = td.ShowModal()
        folder = td.GetPath()
        # Just for WinXP and Older
        if not os.path.isdir(folder):
            wx.MessageBox("The area you selected cannot be saved to.\nPlease start again.", 'Find_SSNs %s' %version.numb, wx.ICON_ERROR)
            td.Destroy()
            sys.exit()
        else:            
            #print response
            if response == wx.ID_OK:
                td.Destroy()
                #print folder
                #print type(folder)
                return str(folder)
            else:
                #print "User selected 'cancel' or 'X' in user.input_folder function"
                td.Destroy()
                sys.exit()

    else:
        pass


def search_for(mode):

    # returns an int

    # -1 means user wants to cancel.
    # 0 means user wants to search for SSNs.
    # 1 means user wants to search for SSNs and CCNs.
    # 2 means user wants to search both, plus account numbers.

    if mode == 'gui':

        import wx

        app = wx.PySimpleApp()
        app.MainLoop()
        i = wx.GetSingleChoiceIndex("What numbers would you like to search for?", "Find_SSNs %s - Search For?" %version.numb, ["U.S. Social Security Numbers", "SSNs and Credit Card Numbers", "SSNs, CCNs, and Account Numbers"])
        if i == -1:
            #print "User selected 'cancel' or 'X' in user.search_for function"
            sys.exit()
        else:
            #print i
            return i

    else:
        pass


def proceed(folder_to_scan, mode):

    # This function only works in gui mode.

    # Create a file called 'status_message.txt' in the same folder as the program
    # and your custom status message will appear instead of the default.
    # This only works in gui mode as no status message is needed for non-gui mode.

    if mode == 'gui':

        import wx

        filename = 'status_message.txt'

        if os.path.isfile(filename):
            fp = open(filename)
            msg = fp.read()
            fp.close()
        else:
            msg = ""
            if folder_to_scan == "/":
                msg = """You have chosen to scan the entire computer. This will include CDs, memory sticks, mounted disk images and connections to servers.  If you do not want to scan any of these, eject or disconnect them before you continue.\n\nWould you like to continue?\n\n"""
            else:
                msg = """The selected folder will now be scanned for sensitive numbers. Would you like to continue?\n\n%s""" %(folder_to_scan)

        app = wx.PySimpleApp()
        app.MainLoop()

        md = wx.MessageDialog(None, msg, 'Find_SSNs %s' %version.numb, wx.YES_NO)
        response =  md.ShowModal()
        #print response
        if response != wx.ID_YES:
            #print 'No'
            md.Destroy()
            #print "User selected 'no' in user.proceed function"
            sys.exit()
        md.Destroy()

    else:
        pass


def wait(mode):
    
    # 4 means user wants to continue
    # 16 means user wants to cancel

    # Create a file called 'wait_message.txt' in the same folder as the program
    # and your custom wait message will appear instead of the default.
    # This works in gui or non-gui mode.

    filename = 'wait_message.txt'

    if os.path.isfile(filename):
        fp = open(filename)
        msg = fp.read()
        fp.close()
    else:
        msg = """There may be periods of inactivity in the program. Please be patient."""

    if mode == 'gui':

        import wx
        
        app = wx.PySimpleApp()
        app.MainLoop()
        ur = wx.MessageBox(msg, 'Find_SSNs %s' %version.numb, wx.CANCEL|wx.OK)
        #print ur
        if ur == 16:
            #print "User selected 'cancel' or 'X' in user.wait function"
            sys.exit()
    else:
        print msg


def end(report_type, path_to_results, mode):

    # Create a file called 'end_message.txt' in the same folder as the program
    # and your custom end message will appear instead of the default.
    # This works in gui or non-gui mode.

    filename = 'end_message.txt'

    if os.path.isfile(filename):
        fp = open(filename)
        msg = fp.read()
        fp.close()
    else:
        msg = """\nThe reports Find_SSNs.%s and Find_SSNs.xml are located here:

%s

Examine the reports carefully. If suspect files were found, verify that they do indeed contain sensitive numbers. If they do and you no longer need them, please securely delete the files. If you need the files, please store them in a secure location and encrypt them.\n\nDelete the reports when you are finished.""" %(report_type, path_to_results)

    if mode == 'gui':

        import wx

        app = wx.PySimpleApp()
        app.MainLoop()
        wx.MessageBox(msg, 'Find_SSNs %s' %version.numb)
    else:
        print msg


def report_type(mode):

    # returns a string
    # skip this in non-gui mode

    # -1 means user wants to cancel.
    # 0 means user wants html.
    # 1 means user wants csv.

    if mode == 'gui':

        import wx

        app = wx.PySimpleApp()
        app.MainLoop()
        i = wx.GetSingleChoiceIndex("Select the type of report you'd like:", "Find_SSNs %s - Select Report Type" %version.numb, ["html", "csv"])
        if i == -1:
            #print "User selected 'cancel' or 'X' in user.report_type function"
            sys.exit()
        if i == 0:
            return 'html'
        if i == 1:
            return 'csv'
    else:
        pass

def simple_scan_type(mode):

    # returns a string
    # skip this in non-gui mode

    # -1 means user wants to cancel.
    # 0 means user wants to scan just the home directory
    # 1 means user wants to scan the whole computer

    if mode == 'gui':

        import wx

        app = wx.PySimpleApp()
        app.MainLoop()
        i = wx.GetSingleChoiceIndex("Select what area to scan:", "Find_SSNs %s - Select Scan Area" %version.numb, ["Home Folder", "Entire Computer", "Custom"])
        if i == -1:
            #print "User selected 'cancel' or 'X' in user.report_type function"
            sys.exit()
        if i == 0:
            return 'home'
        if i == 1:
            return 'all'
        if i == 2:
            return 'custom'
    else:
        pass

def get_encrypt_key(mode):

    # returns a string
    # skip this in non-gui mode

    if mode == 'gui':

        import wx

        app = wx.PySimpleApp()
        app.MainLoop()
        while 1:
            passd = LoginDialog(None,message="Please enter an encryption password for the output")
            key = passd.GetPassword()
            passd.Destroy()
            passd = LoginDialog(None,message="Please the same password again")
            key1 = passd.GetPassword()
            passd.Destroy()

            if key == key1:
                break
            ur = wx.MessageBox('The passwords did not match.  Please try again.','Find_SSNs', wx.OK)
            
        return key
    else:
        pass
