# Copyright (c) 2004 - 2008 16 Systems, LLC
# Copyright (c) 2009 Virginia Polytechnic Institute and State University
# All rights reserved.
#
# License & Redistribution Information
# http://www.security.vt.edu/Find_SSNs/find_ssns_license.html


import socket


# Version Number and Date of Release
numb = '4.2-cornell-0.14'
date = 'June 2011'


# Release Note
#
# 1. Fixed incorrect Copyright year (2002 should have been 2004).
# 2. Re-added 'pdf' to list of skipped extensions. It should not have been removed.
# 3. Clarified usage instructions provided by usage in Find_SSNs.pyw
# 4. Fixed the issue of sys.exit() being called when users try to search 'My Computer'.
#    On XP computers 'My Computer' is not a valid path. Vista disallows this be default
#    as MicroSoft corrected that behavior on systems after XP/2003.
# 5. Added some header skipping just for testing. May slow things down a bit, but will
#    skip dlls, exes, ttfs and ttcs that have unusual file extensions.
# 6. Fixed unscriptable object error on CCN validation failures when valid_ccn returned
#    a None type object that hunt attempted to index. None types cannot be sliced. None[0]
# 7. Cornell version:
#   Added special handling of text, mbox, PS, and doc files
#   Changed details format to XML and added encryption
#   Added separate results viewer program
#   Added skip_paths.txt to skip whole paths

# Hostname and IP of machine running Find_SSNs
try:
    ip = "%s" %socket.gethostbyname(socket.gethostname())
except Exception, e:
    ip = "%s" %e
try:
    host = "%s" %socket.gethostname()
except Exception, e:
    host = "%s" %e
